<?php
/* --------------------------------------------------------------
   StorageOfMultipleTrackingCodesRequested.php 2020-03-25
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Events;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodes;

/**
 * Class StorageOfMultipleTrackingCodesRequested
 *
 * @package Gambio\Admin\TrackingCode\Events
 */
class StorageOfMultipleTrackingCodesRequested
{
    /**
     * @var TrackingCodes
     */
    private $trackingCodes;
    
    
    /**
     * StorageOfMultipleTrackingCodesRequested constructor.
     *
     * @param TrackingCodes $trackingCodes
     */
    private function __construct(TrackingCodes $trackingCodes)
    {
        $this->trackingCodes = $trackingCodes;
    }
    
    
    /**
     * @param TrackingCodes $trackingCodes
     *
     * @return StorageOfMultipleTrackingCodesRequested
     */
    public static function create(TrackingCodes $trackingCodes): StorageOfMultipleTrackingCodesRequested
    {
        return new self($trackingCodes);
    }
    
    
    /**
     * @return TrackingCodes
     */
    public function trackingCodes(): TrackingCodes
    {
        return $this->trackingCodes;
    }
    
    
    /**
     * @param TrackingCodes $trackingCodes
     */
    public function replaceTrackingCodes(TrackingCodes $trackingCodes): void
    {
        $this->trackingCodes = $trackingCodes;
    }
}